/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen.animator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.AnimationUtils;
import lib.toma.animations.IEasing;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.AnimationType;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.api.IKeyframe;
import lib.toma.animations.api.IKeyframeProvider;
import lib.toma.animations.api.event.IAnimationEvent;
import lib.toma.animations.engine.frame.KeyframeProvider;
import lib.toma.animations.engine.screen.animator.Animator;
import lib.toma.animations.engine.screen.animator.FrameProviderWrapper;

public class AnimationProject {
    private final AnimationController controller = new AnimationController();
    private final String name;
    private final FrameProviderWrapper wrapper;
    private final File projectDirectory;
    private boolean isSaved = true;

    public AnimationProject(FrameProviderWrapper wrapper) {
        this.name = wrapper.getName();
        this.projectDirectory = wrapper.getWorkingDirectory();
        this.wrapper = wrapper;
    }

    public AnimationProject(String projectName, int animationLength) {
        this.name = projectName;
        this.controller.setAnimationTime(animationLength);
        this.wrapper = FrameProviderWrapper.userCreated(projectName, new File("./export/providers"), new KeyframeProvider(new HashMap<AnimationStage, IKeyframe[]>(), IAnimationEvent.NO_EVENTS));
        this.projectDirectory = this.wrapper.getWorkingDirectory();
    }

    public static AnimationProject createEmpty() {
        return new AnimationProject(null, 50);
    }

    public AnimationController getAnimationControl() {
        return this.controller;
    }

    public FrameProviderWrapper getFrameControl() {
        return this.wrapper;
    }

    public boolean isNamed() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean isSaved() {
        return this.isSaved;
    }

    public boolean hasEvents() {
        return this.wrapper.hasEventSupport();
    }

    public void saveProject() {
        if (this.name == null) {
            return;
        }
        try {
            File file = new File(this.projectDirectory, this.name + ".json");
            if (file.exists()) {
                this.saveToDisk(file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.isSaved = true;
    }

    public void saveProjectAs(String name) {
        try {
            File file;
            if (!this.projectDirectory.exists()) {
                this.projectDirectory.mkdirs();
            }
            if (!(file = new File(this.projectDirectory, name + ".json")).exists()) {
                file.createNewFile();
            }
            this.saveToDisk(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.isSaved = true;
    }

    private void saveToDisk(File file) throws IOException {
        IKeyframeProvider serializable = this.wrapper.getProvider().toSerializable();
        String out = AnimationEngine.get().loader().serializeResource(serializable);
        try (FileWriter fw = new FileWriter(file);){
            fw.write(out);
        }
    }

    public static class AnimationController {
        private int animationTime = 50;
        private boolean isOnRepeat = false;
        private boolean paused = true;
        private IEasing easing = AnimationUtils.DEFAULT_EASE_FUNC;

        public void setAnimationTime(int animationTime) {
            this.animationTime = animationTime;
            IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
            AnimationType<Animator.CustomizableAnimation> type = Animator.ANIMATOR_TYPE;
            if (type == null) {
                return;
            }
            Animator.CustomizableAnimation animation = pipeline.get(type);
            if (animation != null) {
                animation.setTickLength(animationTime);
            }
        }

        public int getAnimationTime() {
            return this.animationTime;
        }

        public void setOnRepeat(boolean onRepeat) {
            this.isOnRepeat = onRepeat;
        }

        public boolean isOnRepeat() {
            return this.isOnRepeat;
        }

        public void setPaused(boolean paused) {
            this.paused = paused;
        }

        public boolean isPaused() {
            return this.paused;
        }

        public IEasing getEasing() {
            return this.easing;
        }

        public void setEasing(IEasing easing) {
            this.easing = easing;
        }
    }
}

